<?= $this->extend('layouts/admin') ?>

<?= $this->section('content') ?>
<div class="d-flex justify-content-between align-items-center mb-4">
    <h2 class="mb-0">
        <i class="bi bi-award me-2"></i>Kelola Sertifikat
    </h2>
    <a href="<?= base_url('admin/certificates/create') ?>" class="btn btn-primary">
        <i class="bi bi-plus me-1"></i>Tambah Sertifikat
    </a>
</div>

<?php if (session()->getFlashdata('success')): ?>
    <div class="alert alert-success alert-dismissible fade show" role="alert">
        <?= session()->getFlashdata('success') ?>
        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
    </div>
<?php endif; ?>

<?php if (session()->getFlashdata('error')): ?>
    <div class="alert alert-danger alert-dismissible fade show" role="alert">
        <?= session()->getFlashdata('error') ?>
        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
    </div>
<?php endif; ?>

<div class="admin-card">
    <div class="table-responsive">
        <table class="table table-hover">
            <thead>
                <tr>
                    <th>No</th>
                    <th>Nama Sertifikat</th>
                    <th>Penerbit</th>
                    <th>Tanggal Terbit</th>
                    <th>Status</th>
                    <th>Aksi</th>
                </tr>
            </thead>
            <tbody>
                <?php if (empty($certificates)): ?>
                    <tr>
                        <td colspan="6" class="text-center py-4">
                            <i class="bi bi-inbox display-4 text-muted"></i>
                            <p class="mt-2 text-muted">Belum ada data sertifikat</p>
                        </td>
                    </tr>
                <?php else: ?>
                    <?php foreach ($certificates as $index => $cert): ?>
                        <tr>
                            <td><?= $index + 1 ?></td>
                            <td>
                                <strong><?= esc($cert['nama_sertifikat']) ?></strong>
                                <?php if ($cert['nomor_sertifikat']): ?>
                                    <br><small class="text-muted">No: <?= esc($cert['nomor_sertifikat']) ?></small>
                                <?php endif; ?>
                            </td>
                            <td><?= esc($cert['penerbit']) ?></td>
                            <td><?= date('d/m/Y', strtotime($cert['tanggal_terbit'])) ?></td>
                            <td>
                                <?php if ($cert['tanggal_expired'] && strtotime($cert['tanggal_expired']) < time()): ?>
                                    <span class="badge bg-danger">Expired</span>
                                <?php else: ?>
                                    <span class="badge bg-success">Aktif</span>
                                <?php endif; ?>
                            </td>
                            <td>
                                <div class="btn-group btn-group-sm">
                                    <a href="<?= base_url('admin/certificates/edit/' . $cert['id']) ?>" 
                                       class="btn btn-outline-primary" title="Edit">
                                        <i class="bi bi-pencil"></i>
                                    </a>
                                    <a href="<?= base_url('admin/certificates/delete/' . $cert['id']) ?>" 
                                       class="btn btn-outline-danger" title="Hapus"
                                       onclick="return confirm('Yakin ingin menghapus sertifikat ini?')">
                                        <i class="bi bi-trash"></i>
                                    </a>
                                </div>
                            </td>
                        </tr>
                    <?php endforeach; ?>
                <?php endif; ?>
            </tbody>
        </table>
    </div>
</div>
<?= $this->endSection() ?>